#pragma transparent
#pragma body

float mpi = 3.1415926535897932384626433832795;
// scenekit stashes time in scn_frame
float iTime = scn_frame.time;

// grab uv coords from our material
float2 uv = _surface.diffuseTexcoord;

// transform uv coordinates if needed
float2 p = 1.0*uv;

// length and angle from center for fancy polar coord dist.
float r = length(p);
float a = atan(p.y / p.x);

//classic demo fx
float2 uvmod = float2(
    atan2(p.y, p.x) / (mpi * 2.0),
    acos(-in.normal.z) / mpi
);
      


// get the diffuse sampler and get color at distorted uv coords
float4 texcol = u_diffuseTexture.sample(u_diffuseTextureSampler, uvmod);
_output.color.rgba = texcol;
